/*********************************************************************
* 
*   cCircBuf_var_el.h
* 
*	Circular buffer with variable-length elements.
*	See .cpp file for more notes.
* 
*	Copyright 2020 Robert Sacks.  https://mojoware.org
*
*********************************************************************/

#pragma once

#include <Windows.h>

class cCircBuf_var_el
{
public:

	struct sEntry
	{
		sEntry () : pNext(0), uPayloadLen(0) {}
		size_t size () { return sizeof(sEntry) + uPayloadLen - 4; }
		size_t uPayloadLen;
		sEntry * pNext;
		BYTE aPayload[4];
	};

	cCircBuf_var_el ( size_t uBufSizeA )
	{
		InitializeCriticalSectionAndSpinCount( &_cs, 4000 );
		_uBufSize = uBufSizeA;
		_pBuf = new BYTE [ _uBufSize ];
		_pHead = _pTail = 0;
	};

	bool put ( BYTE * p, size_t uLenA );
	bool put_without_write_and_get_buffer ( BYTE ** ppRet, size_t uLenA );
	bool pop ( size_t * pQtyWritten, BYTE * pRet, size_t uBufSize );
	bool pop (); // discards value

	size_t qty ();

	void lock () { EnterCriticalSection ( &_cs ); }
	void unlock () { LeaveCriticalSection ( & _cs ); }

	#ifdef CIRC_BUF_VAR_EL_TEST
		bool test ();
	#endif

private:

	CRITICAL_SECTION _cs;
	size_t   _uBufSize;
	BYTE *   _pBuf;
	sEntry * _pHead;
	sEntry * _pTail;
};