/***********************************************************************************************************************
/*
/*  KillMutex :: main.cpp
/*
/*  Copyright 2008-2021 Robert Sacks.  https://mojoware.org
/*
/*  0.0.3.2 2021 jun 5: added test for 32 bit process on 64 bit windows
/*  0.0.3.1 2021 may 6: changed timer from GetTickCount to cQueryPerformanceCounter
/*  0.0.3.1 2021 may 6: added version resource
/*  0.0.3.1 2021 may 6: set warning level /W4; renamed variables to avoid warning
/*  0.0.3.0 2021 may 5: put project in its own solution; revised banner
/*
/**********************************************************************************************************************/

#include "stdafx.h"
#include "is_64_bit_windows.j.h"

//======================================================================================================================
//  DATA
//======================================================================================================================

static const wchar_t s_awVersion [] = { L"0.0.3.2" };

//======================================================================================================================
//  CODE
//======================================================================================================================

//----------------------------------------------------------------------------------------------------------------------
//  MAIN
//  Names of mutexes are supplied as arguments
//----------------------------------------------------------------------------------------------------------------------
int wmain ( int argc, wchar_t * argv [] )
{
	wprintf (	L"\nKillMutex version %s\n"
				L"https://mojoware.org\n"
				L"Copyright (c) 2008-2021 Robert Sacks\n\n",
				s_awVersion );

	if ( ( ! is_64_bit_process() ) && is_64_bit_windows() )
	{
		wprintf ( L"You are using a 32-bit version of this\n"
			      L"program on 64-bit Windows.  Please switch\n"
			      L"to a 64-bit version of this program.\n" );

		return -1;
	}

	if ( argc < 2 )
		wprintf ( L"No mutex names were supplied; counting only.\n\n" );

	cQueryPerformanceCounter timer;

	wchar_t awResult [4096] = {0};

	int iResult = kill_mutex ( awResult, sizeof(awResult)/sizeof(wchar_t), (const wchar_t **) ( argv + 1 ) );

	double dElapsedSeconds = timer.elapsed_seconds();

	if ( awResult[0] )
		wprintf ( L"%s", awResult );

	wprintf ( L"Time elapsed: %0.7f seconds\n", dElapsedSeconds );

	return iResult;
}

