/************************************************************************************************************************
/*
/*  KillMutex :: kill_mutex.j.cpp
/*
/*  Entry point is kill_mutex().  
/*  On error, it returns -1 and includes "Error:\n" in the returned string.
/*
/*  Copyright (c) 2005-2021 Robert Sacks.  https://mojoware.org
/*
/************************************************************************************************************************/

#include "stdafx.h"
#include "winternl.h"

//=======================================================================================================================
//  SYSTEM TYPEDEFS
//=======================================================================================================================

typedef struct _SYSTEM_HANDLE_ENTRY 
{
	ULONG  OwnerPid;
	BYTE   ObjectType;
	BYTE   HandleFlags;
	USHORT HandleValue;
	PVOID  ObjectPointer;
	ULONG  AccessMask;
} SYSTEM_HANDLE_ENTRY, *PSYSTEM_HANDLE_ENTRY;
 
typedef struct _SYSTEM_HANDLE_INFORMATION 
{
	ULONG  Count;
	SYSTEM_HANDLE_ENTRY Handle[1];
} SYSTEM_HANDLE_INFORMATION, *PSYSTEM_HANDLE_INFORMATION;

typedef NTSTATUS NTAPI NT_QUERY_OBJECT ( HANDLE, int , PVOID, ULONG, PULONG );

typedef NTSTATUS WINAPI NT_QUERY_SYSTEM_INFORMATION ( SYSTEM_INFORMATION_CLASS, PVOID, ULONG, PULONG );

typedef struct _OBJECT_NAME_INFORMATION
{
	UNICODE_STRING ObjectName;
	ULONG Reserved[22];
} OBJECT_NAME_INFORMATION, *POBJECT_NAME_INFORMATION;


//=======================================================================================================================
// PROTOTYPES
//=======================================================================================================================

bool get_type_name_from_system_handle_entry	(	wchar_t * awErrorRet, int iSizeOfErrorRet, 
												NT_QUERY_OBJECT * pfNtQueryObject,
												wchar_t * awName, int iSizeOfName, SYSTEM_HANDLE_ENTRY * pShe );

//=======================================================================================================================
// CODE
//=======================================================================================================================

//-----------------------------------------------------------------------------------------------------------------------
//  IS MUTANT
//  Return value of false may indicate error condition.
//  This function builds up a dictionary of ObjectTypes so it can determine which ObjectType (which number)
//	indicates "mutant" on the user's version of Windows.
//-----------------------------------------------------------------------------------------------------------------------
bool is_mutant ( wchar_t * awErrorRet, int iSizeOfErrorRet, NT_QUERY_OBJECT * pfNtQueryObject, SYSTEM_HANDLE_ENTRY * pShe )
{
#if 0

	awErrorRet, iSizeOfErrorRet, pfNtQueryObject;

	if ( 11 == pShe->ObjectType )
		return true;
	else
		return false;

#else

	static bool abTypesFound [256] = {0};
	static bool bMutantTypeFound = false;
	static BYTE yMutantType = 0;
	awErrorRet[0] = 0;
	static int iIterations = 0;

	iIterations++;

	if ( sizeof(abTypesFound) <= pShe->ObjectType )
	{
		StringCchCat ( awErrorRet, iSizeOfErrorRet, L"ObjectType out of range in is_mutant() in kill_mutex.j.cpp.\n" );
		return false;
	}

	if ( bMutantTypeFound )
	{
		if ( pShe->ObjectType == yMutantType )
			return true;

		else
			return false;
	}

	else if ( abTypesFound[pShe->ObjectType] )
		return false;

	else
	{
		wchar_t awName[1024];
		const int iSizeOfName = sizeof(awName)/sizeof(wchar_t);

		if ( get_type_name_from_system_handle_entry ( awErrorRet, iSizeOfErrorRet, pfNtQueryObject, awName, iSizeOfName, pShe ) )
		{
			abTypesFound[pShe->ObjectType] = true;

			if ( 0 == wcscmp ( L"Mutant", awName ) )
			{
				bMutantTypeFound = true;
				yMutantType = pShe->ObjectType;
				return true;
			}
		}

		return false;
	}
#endif
}
	

//-----------------------------------------------------------------------------------------------------------------------
//  GET TYPE NAME FROM STSTEM HANDLE ENTRY
//  h is the handle 
//-----------------------------------------------------------------------------------------------------------------------
bool get_type_name_from_system_handle_entry	(	wchar_t * awErrorRet, int iSizeOfErrorRet, 
												NT_QUERY_OBJECT * pfNtQueryObject,
												wchar_t * awName, int iSizeOfName, SYSTEM_HANDLE_ENTRY * pShe )
{
	iSizeOfErrorRet;

	if ( awErrorRet )
		awErrorRet[0] = 0;

	awName[0] = 0;

	struct sOniPlus
	{
		OBJECT_NAME_INFORMATION oni;
		wchar_t buf [ 2048 ];
	} Oni;

	HANDLE hSourceProcess = OpenProcess ( PROCESS_QUERY_LIMITED_INFORMATION | PROCESS_DUP_HANDLE, FALSE, pShe->OwnerPid );

	bool bRetVal = false;

	if ( hSourceProcess )
	{
		HANDLE hObjHandle;

		if ( DuplicateHandle ( hSourceProcess, (HANDLE) pShe->HandleValue, GetCurrentProcess(), &hObjHandle, STANDARD_RIGHTS_ALL, TRUE, 0 ) )
		{
			DWORD dwReturnLength;

			Oni.oni.ObjectName.Buffer = &Oni.buf[0]; 
			Oni.oni.ObjectName.Length = 0;
			Oni.oni.ObjectName.MaximumLength = sizeof(Oni.buf);

			NTSTATUS status = pfNtQueryObject ( hObjHandle, ObjectTypeInformation, &Oni.oni, sizeof(Oni.buf), &dwReturnLength );

			if ( 0 == status )
			{
				int iObjectType = pShe->ObjectType; iObjectType;
				StringCchCatW ( awName, iSizeOfName, Oni.oni.ObjectName.Buffer );
				bRetVal = true;
			}

			CloseHandle ( hObjHandle );
		}

		CloseHandle ( hSourceProcess );
	}

	return bRetVal;
}


//-----------------------------------------------------------------------------------------------------------------------
//  KILL MUTEX
//  returns -1 on error
//  or positive number of handles found on success
//-----------------------------------------------------------------------------------------------------------------------
int kill_mutex ( wchar_t * awRet, size_t iSize, const wchar_t ** ppName )
{
	//---------------------------------
	//  GET SE DEBUG PRIVILEGE
	//---------------------------------

	cPrivilege Privilege;

	//---------------------------------
	//  GET OS FUNCTION POINTERS
	//---------------------------------

	HMODULE hLib = LoadLibrary ( L"ntdll.dll" );

	if ( ! hLib )
		return -1;

	NT_QUERY_SYSTEM_INFORMATION * pfQuerySystemInformation =
	   ( NT_QUERY_SYSTEM_INFORMATION * ) GetProcAddress ( hLib, "NtQuerySystemInformation" );

	if ( ! pfQuerySystemInformation )
	{
		StringCchCatW ( awRet, iSize, L"Can't get address of NtQuerySystemInformation.\n" ); 
		return -1;
	}

	NT_QUERY_OBJECT * pfNtQueryObject = ( NT_QUERY_OBJECT * ) GetProcAddress ( hLib, "NtQueryObject" );

	if ( ! pfNtQueryObject )
	{
		StringCchCatW ( awRet, iSize, L"Can't get address of NtQueryObject.\n" ); 
		return -1;
	}

	//---------------------------------
	//  CALL NtQuerySystemInformation
	//  TO GET LIST OF HANDLE INFO
	//---------------------------------

	const int iSIZE_OF_BUF = 1024;
	BYTE * pBuf = 0;
	DWORD dwReturnLengthQsi = iSIZE_OF_BUF;
	NTSTATUS statusQsi = 0;

	for ( int i = 0; i < 20; i++ )
	{
		if ( pBuf )
			delete[] pBuf;

		pBuf = new BYTE [ dwReturnLengthQsi ];

		statusQsi = pfQuerySystemInformation ( ( _SYSTEM_INFORMATION_CLASS ) 16, pBuf, dwReturnLengthQsi, &dwReturnLengthQsi );

		if ( ! statusQsi )
			break;

		dwReturnLengthQsi += 10000;
	}

	if ( statusQsi )
	{
		StringCchCatW ( awRet, iSize, L"Can't get system handle info from NtQuerySystemInformation.\n" ); 
		return -1;
	}

	///---------------------------------
	//  VARIABLES
	//---------------------------------

	SYSTEM_HANDLE_INFORMATION * pSysHandleInfo = ( SYSTEM_HANDLE_INFORMATION * ) pBuf ;

	SYSTEM_HANDLE_ENTRY * pSysHandleEntry = &pSysHandleInfo->Handle[0];

	const int iONI_BUFFER_SIZE = MAX_PATH * 4 * sizeof(wchar_t);

	struct sOniPlus
	{
		OBJECT_NAME_INFORMATION oni;
		wchar_t awBuf [ iONI_BUFFER_SIZE + 1 ];
	} Oni;

	memset ( &Oni, 0, sizeof(Oni) );

	HANDLE hThisProcess = GetCurrentProcess();

	int iQtyFound = 0;

	//-------------------------------------------------------------------------------------------------------------------
	//  DISPLAY NUMBER OF HANDLES
	//-------------------------------------------------------------------------------------------------------------------
	{
		wchar_t awTemp[4096];
		StringCchPrintf ( awTemp, sizeof(awTemp)/sizeof(wchar_t), L"Quantity system handles: %u\n", pSysHandleInfo->Count );
		StringCchCatW ( awRet, iSize, awTemp );
	}

	//-------------------------------------------------------------------------------------------------------------------
	//  QUIT NOW IF NO MUTEX NAMES WERE SUPPLIED
	//-------------------------------------------------------------------------------------------------------------------

	if ( ! *ppName )
		return 0;

	//-------------------------------------------------------------------------------------------------------------------
	//  ITERATE THROUGH SYSTEM HANDLES
	//-------------------------------------------------------------------------------------------------------------------

	for ( unsigned j = 0; j < pSysHandleInfo->Count; j++ )
	{
		//---------------------------------------------
		//  SKIP PIPES BECAUSE THEY CAUSE ONE OF THE
		//  FOLLOWING FUNCTIONS TO HANG
		//---------------------------------------------

		if ( pSysHandleEntry[j].AccessMask == 0x0012019F )
			continue;

		//---------------------------------------------
		//  SKIP EVERYTHING EXCEPT MUTEXES
		//---------------------------------------------

		wchar_t awError[2048] = {0};

		if ( ! is_mutant ( awError, sizeof(awError), pfNtQueryObject, &pSysHandleEntry[j] ) )
		{
			if ( awError[0] )
			{
				StringCchCat ( awRet, iSize, L"Error:\n" );
				StringCchCat ( awRet, iSize, awError );
				return -1;
			}

			else continue;
		}

		HANDLE hSourceProcess = OpenProcess ( PROCESS_QUERY_LIMITED_INFORMATION | PROCESS_DUP_HANDLE, FALSE, pSysHandleEntry[j].OwnerPid );

		if ( hSourceProcess )
		{
			HANDLE hObjHandle;

			if ( DuplicateHandle ( hSourceProcess, (HANDLE) pSysHandleEntry[j].HandleValue, hThisProcess, &hObjHandle, MUTEX_ALL_ACCESS, TRUE, 0 ) )
			{
				DWORD dwReturnLength;

				Oni.oni.ObjectName.Buffer = &Oni.awBuf[0]; 
				Oni.oni.ObjectName.Length = 0;
				Oni.oni.ObjectName.MaximumLength = iONI_BUFFER_SIZE;

				NTSTATUS status = pfNtQueryObject ( hObjHandle, 1, &Oni.oni, iONI_BUFFER_SIZE, &dwReturnLength );

				if ( 0 == status && Oni.oni.ObjectName.Buffer )
				{
					for ( const wchar_t ** pp = ppName; *pp; pp++ )
					{
						if ( 0 == wcscmp ( *pp, Oni.oni.ObjectName.Buffer ) )
						{
							//---------------------------------------------
							//  CLOSE THE OTHER PROCESS'S HANDLE
							//---------------------------------------------

							HANDLE hRemoteHandle;
							DuplicateHandle ( hSourceProcess, (HANDLE) pSysHandleEntry[j].HandleValue, hThisProcess, &hRemoteHandle, MUTEX_ALL_ACCESS, TRUE, DUPLICATE_CLOSE_SOURCE );
							CloseHandle ( hRemoteHandle );

							iQtyFound ++;
							wchar_t awTemp[4096];
							StringCchPrintf ( awTemp, sizeof(awTemp)/sizeof(wchar_t), L"Deleted %s\n", *pp );
							StringCchCatW ( awRet, iSize, awTemp ); 
							break;
						}
					}
				}

				CloseHandle ( hObjHandle );
			}

			CloseHandle ( hSourceProcess );
		}
	}

	if ( hThisProcess )
		CloseHandle ( hThisProcess );

	if ( pBuf )
		delete[] pBuf;

	if ( 0 < iQtyFound )
		return iQtyFound;

	else if ( 0 == iQtyFound )
	{
		StringCchCatW ( awRet, iSize, L"No mutex was found.\n" ); 
		return 0;
	}

	else
		return -1;
}

