/***********************************************************************************************************************
/*
/*  KillMutex :: cPrivilege.h
/*
/*  Copyright 2008-2021 Robert Sacks.  https://mojoware.org
/*
/**********************************************************************************************************************/

#pragma once

//----------------------------------------------------------------------------------------------------------------------
//  CLASS PRIVILEGE
//  Wraps call to set/unset elevated privilege
//  As long as this object lives, the calling thread's privilege level
//  remains changed
//----------------------------------------------------------------------------------------------------------------------
class cPrivilege
{
public:

	cPrivilege ( const wchar_t * pArgPrivilegeName = SE_DEBUG_NAME );
	~cPrivilege ();

private:

	HANDLE hToken;
	wchar_t * pPrivilegeName;
};


//----------------------------------------------------------------------------------------------------------------------
//  NON-CLASS PROTYPES
//----------------------------------------------------------------------------------------------------------------------
BOOL set_privilege (	HANDLE hToken,				// access token handle
						LPCTSTR lpszPrivilege,		// name of privilege to enable/disable
						BOOL bEnablePrivilege  );	// to enable or disable privilege

bool get_thread_token ( HANDLE * phToken);


